% This procedure creates table 15
% It uses the estimation results produced in GMM_main
clear

load ../../'Estimation Results'/Benchmark_Model.mat parameters

benchm_par = parameters;

load ../../'Estimation Results'/competitive_model.mat 
disp(' ')
disp('Table 15: Estimated parameters: OPEC behaves competitively')
disp(' ')
disp( 'Parameter        Estimate    (s.e.)   Benchm. Estimate')
disp(['epsilon            ' num2str(parameters(13), '%.3f') '     (' num2str(std_error(1), '%.2f') ')        ' num2str(benchm_par(13), '%.2f')])
disp(['rho_a1             ' num2str(parameters(14), '%.2f') '      (' num2str(std_error(2), '%.2f') ')        ' num2str(benchm_par(14), '%.2f')])
disp(['rho_a2            ' num2str(parameters(15), '%.2f') '      (' num2str(std_error(3), '%.2f') ')       ' num2str(benchm_par(15), '%.2f')])
disp(['sd_a               ' num2str(parameters(17)^(0.5), '%.3f') '     (' num2str(0.5*std_error(5)/parameters(17)^(0.5), '%.3f') ')       ' num2str(benchm_par(17)^(0.5), '%.3f')]) % using Delta method
disp(['sd_u               ' num2str(parameters(16)^(0.5), '%.2f') '      (' num2str(0.5*std_error(4)/parameters(16)^(0.5), '%.3f') ')       ' num2str(benchm_par(16)^(0.5), '%.2f')]) % using Delta method

